IF  EXISTS( SELECT  * FROM  SYS.OBJECTS 
	WHERE  NAME LIKE 'P_EST_NF_ENT_DANFE_PROVISORIO_EXCLUSAO_RESTORE' AND TYPE = 'P' )
BEGIN
	DROP PROCEDURE P_EST_NF_ENT_DANFE_PROVISORIO_EXCLUSAO_RESTORE 
END
GO
--EXEC P_EST_NF_ENT_DANFE_PROVISORIO_EXCLUSAO_RESTORE '18.8.6.1200'
CREATE PROCEDURE P_EST_NF_ENT_DANFE_PROVISORIO_EXCLUSAO_RESTORE @VERSAO_INFE_EXCLUSAO VARCHAR(50), 
																@CD_CTR_PAR INT=0
WITH ENCRYPTION AS
SET NOCOUNT ON;
DECLARE @CD_CTR INT

CREATE TABLE #RsDanfePendente (CD_CTR INT)

INSERT INTO #RsDanfePendente
SELECT
	CD_CTR
FROM
	EST_NF_ENT_DANFE_PROVISORIO_PENDENTE
WHERE
	CD_CTR = CASE WHEN @CD_CTR_PAR=0 THEN CD_CTR ELSE @CD_CTR_PAR END

--Criando restore com pedido de compras
INSERT INTO EST_NF_ENT_DANFE_PROVISORIO_EST_PED_CP_RESTORE
(CD_EMP,
CD_FILIAL,
CD_FORN,
NR_NF,
DT_EMIS_NF,
CD_PED,
CD_USU,
VERSAO)
SELECT
	D.CD_EMP,
	D.CD_FILIAL,
	D.CD_FORN,
	D.NR_NF,
	D.DT_EMIS_NF,
	PED.CD_PED,
	PED.CD_USU,
	D.VERSAO	 
FROM
	EST_NF_ENT_DANFE_PROVISORIO D INNER JOIN  #RsDanfePendente  P ON
	D.CD_CTR = P.CD_CTR 
	LEFT OUTER JOIN EST_NF_ENT_DANFE_PROVISORIO_EST_PED_CP_RESTORE R ON
	D.CD_EMP = R.CD_EMP AND
	D.CD_FILIAL = R.CD_FILIAL AND
	D.CD_FORN = R.CD_FORN AND
	D.NR_NF = R.NR_NF AND
	D.DT_EMIS_NF = R.DT_EMIS_NF 
	INNER JOIN EST_NF_ENT_DANFE_PROVISORIO_EST_PED_CP PED ON
	D.CD_CTR = PED.CD_CTR 
WHERE
	R.NR_NF IS NULL
	AND D.VERSAO <> @VERSAO_INFE_EXCLUSAO

--Criando pre-entrada
INSERT INTO EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_PRE_ENTRADA_RESTORE
(CD_EMP,
CD_FILIAL,
CD_FORN,
NR_NF,
DT_EMIS_NF,
CD_CTR_PRE_ENTRADA,
VERSAO)
SELECT
	D.CD_EMP,
	D.CD_FILIAL,
	D.CD_FORN,
	D.NR_NF,
	D.DT_EMIS_NF,
	PENT.CD_CTR_PRE_ENTRADA,
	D.VERSAO	
FROM
	EST_NF_ENT_DANFE_PROVISORIO D INNER JOIN  #RsDanfePendente  P ON
	D.CD_CTR = P.CD_CTR 
	LEFT OUTER JOIN EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_PRE_ENTRADA_RESTORE R ON
	D.CD_EMP = R.CD_EMP AND
	D.CD_FILIAL = R.CD_FILIAL AND
	D.CD_FORN = R.CD_FORN AND
	D.NR_NF = R.NR_NF AND
	D.DT_EMIS_NF = R.DT_EMIS_NF 
	INNER JOIN EST_NF_ENT_DANFE_PROVISORIO_EST_NF_ENT_PRE_ENTRADA PENT ON
	D.CD_CTR = PENT.CD_CTR 
WHERE
	R.NR_NF IS NULL
	AND D.VERSAO <> @VERSAO_INFE_EXCLUSAO

--Criando cabecalho do checkin
INSERT INTO EST_NF_ENT_DANFE_PROVISORIO_CHECKIN_ENTRADA_RESTORE
(CD_EMP,
CD_FILIAL,
CD_FORN,
NR_NF,
DT_EMIS_NF,
CD_USU,
CHECKIN_DIVERGENCIA,
VERSAO
)
SELECT
	D.CD_EMP,
	D.CD_FILIAL,
	D.CD_FORN,
	D.NR_NF,
	D.DT_EMIS_NF,
	CHK.CD_USU,
	CHK.CHECKIN_DIVERGENCIA,
	D.VERSAO
FROM
	EST_NF_ENT_DANFE_PROVISORIO D INNER JOIN  #RsDanfePendente  P ON
	D.CD_CTR = P.CD_CTR 
	LEFT OUTER JOIN EST_NF_ENT_DANFE_PROVISORIO_CHECKIN_ENTRADA_RESTORE R ON
	D.CD_EMP = R.CD_EMP AND
	D.CD_FILIAL = R.CD_FILIAL AND
	D.CD_FORN = R.CD_FORN AND
	D.NR_NF = R.NR_NF AND
	D.DT_EMIS_NF = R.DT_EMIS_NF 
	INNER JOIN EST_NF_ENT_DANFE_PROVISORIO_CHECKIN_ENTRADA CHK ON
	D.CD_CTR = CHK.CD_CTR 
WHERE
	R.NR_NF IS NULL
	AND D.VERSAO <> @VERSAO_INFE_EXCLUSAO


--Criando checkin complemento
INSERT INTO EST_NF_ENT_DANFE_PROVISORIO_CHECKIN_ENTRADA_CPL_RESTORE
(CD_EMP,
CD_FILIAL,
CD_FORN,
NR_NF,
DT_EMIS_NF,
CD_PROD,
QT_IT_CHECK,
VERSAO)
SELECT
	D.CD_EMP,
	D.CD_FILIAL,
	D.CD_FORN,
	D.NR_NF,
	D.DT_EMIS_NF,
	CHKCPL.CD_PROD,
	CHKCPL.QT_IT_CHECK,
	D.VERSAO
FROM
	EST_NF_ENT_DANFE_PROVISORIO D INNER JOIN  #RsDanfePendente  P ON
	D.CD_CTR = P.CD_CTR 
	LEFT OUTER JOIN EST_NF_ENT_DANFE_PROVISORIO_CHECKIN_ENTRADA_CPL_RESTORE R ON
	D.CD_EMP = R.CD_EMP AND
	D.CD_FILIAL = R.CD_FILIAL AND
	D.CD_FORN = R.CD_FORN AND
	D.NR_NF = R.NR_NF AND
	D.DT_EMIS_NF = R.DT_EMIS_NF 
	INNER JOIN EST_NF_ENT_DANFE_PROVISORIO_CHECKIN_ENTRADA_CPL CHKCPL ON
	D.CD_CTR = CHKCPL.CD_CTR 
WHERE
	R.NR_NF IS NULL
	AND D.VERSAO <> @VERSAO_INFE_EXCLUSAO

--Criando ciencia da operacao
INSERT INTO EST_NF_ENT_DANFE_PROVISORIO_CIENCIA_OPERACAO_RESTORE
(CD_EMP,
CD_FILIAL,
CD_FORN,
NR_NF,
DT_EMIS_NF,
NR_PROTOCOLO,
DIG_VALIDACAO,
DATA_VALIDACAO,
DT_CAD,
VERSAO)
SELECT
	D.CD_EMP,
	D.CD_FILIAL,
	D.CD_FORN,
	D.NR_NF,
	D.DT_EMIS_NF,
	CIENCIA.NR_PROTOCOLO,
	CIENCIA.DIG_VALIDACAO,
	CIENCIA.DATA_VALIDACAO,
	GETDATE(),
	D.VERSAO	 
FROM
	EST_NF_ENT_DANFE_PROVISORIO D INNER JOIN  #RsDanfePendente  P ON
	D.CD_CTR = P.CD_CTR 
	INNER JOIN EST_NF_ENT_DANFE_PROVISORIO_CIENCIA_OPERACAO_RESTORE R ON
	D.CD_EMP = R.CD_EMP AND
	D.CD_FILIAL = R.CD_FILIAL AND
	D.CD_FORN = R.CD_FORN AND
	D.NR_NF = R.NR_NF AND
	D.DT_EMIS_NF = R.DT_EMIS_NF 	
	LEFT OUTER JOIN EST_NF_ENT_DANFE_PROVISORIO_CIENCIA_OPERACAO CIENCIA ON
	D.CD_CTR = CIENCIA.CD_CTR 
WHERE
	R.NR_NF IS NULL
	AND D.VERSAO <> @VERSAO_INFE_EXCLUSAO

--Criando liberacao de danfe
INSERT INTO EST_NF_ENT_DANFE_PROVISORIO_LIBERACAO_RESTORE
(CD_EMP,
CD_FILIAL,
CD_FORN,
NR_NF,
DT_EMIS_NF,
CD_USU,
DT_CAD,
TIPO_BLQ,
CD_PED_COMPRA,
DT_LIBERACAO,
CD_USU_LIB,
OBS_LIB,
DT_HR_CAD)
SELECT
	D.CD_EMP,
	D.CD_FILIAL,
	D.CD_FORN,
	D.NR_NF,
	D.DT_EMIS_NF,
	LIB.CD_USU,
	GETDATE(),
	LIB.TIPO_BLQ,
	LIB.CD_PED_COMPRA,
	LIB.DT_LIBERACAO,
	LIB.CD_USU_LIB,
	LIB.OBS_LIB,
	LIB.DT_HR_CAD
FROM
	EST_NF_ENT_DANFE_PROVISORIO D INNER JOIN  #RsDanfePendente  P ON
	D.CD_CTR = P.CD_CTR 
	LEFT OUTER JOIN EST_NF_ENT_DANFE_PROVISORIO_LIBERACAO_RESTORE R ON
	D.CD_EMP = R.CD_EMP AND
	D.CD_FILIAL = R.CD_FILIAL AND
	D.CD_FORN = R.CD_FORN AND
	D.NR_NF = R.NR_NF AND
	D.DT_EMIS_NF = R.DT_EMIS_NF 	 
	INNER  JOIN EST_NF_ENT_DANFE_PROVISORIO_LIBERACAO LIB ON
	D.CD_CTR = LIB.CD_CTR
WHERE
	R.NR_NF IS NULL
	AND D.VERSAO <> @VERSAO_INFE_EXCLUSAO

--Criando liberacao de danfe
INSERT INTO EST_NF_ENT_DANFE_PROVISORIO_PENDENTE_RESTORE
(CD_CTR,
CD_EMP,
CD_FILIAL,
CD_FORN,
NR_NF,
DT_EMIS_NF,
VERSAO,
NR_AUTORIZADOR,
CD_MOV_OP,
CD_USU_LIBEROU_ENTRADA,
FLAG_LIBERA_ENTRADA_SEM_PEDIDO,
FLAG_REPOSICAO_PBM)
SELECT
	D.CD_CTR,
	D.CD_EMP,
	D.CD_FILIAL,
	D.CD_FORN,
	D.NR_NF,
	D.DT_EMIS_NF,
	D.VERSAO,
	D.NR_AUTORIZADOR,
	D.CD_MOV_OP,
	D.CD_USU_LIBEROU_ENTRADA,
	D.FLAG_LIBERA_ENTRADA_SEM_PEDIDO,
	D.FLAG_REPOSICAO_PBM
FROM
	EST_NF_ENT_DANFE_PROVISORIO D INNER JOIN  #RsDanfePendente  P ON
	D.CD_CTR = P.CD_CTR 
	LEFT OUTER JOIN EST_NF_ENT_DANFE_PROVISORIO_PENDENTE_RESTORE R ON
	D.CD_EMP = R.CD_EMP AND
	D.CD_FILIAL = R.CD_FILIAL AND
	D.CD_FORN = R.CD_FORN AND
	D.NR_NF = R.NR_NF AND
	D.DT_EMIS_NF = R.DT_EMIS_NF 	 
WHERE
	R.NR_NF IS NULL
	AND D.VERSAO <> @VERSAO_INFE_EXCLUSAO

	UPDATE
		EST_NF_NFE_RECEBIMENTO
	SET
		STS_IMPORT=6,
		DH_IMPORT=GETDATE()
		
	FROM
		EST_NF_NFE_RECEBIMENTO INNER JOIN EST_NF_ENT_DANFE_PROVISORIO_PENDENTE_RESTORE ON
		EST_NF_NFE_RECEBIMENTO.CHAVE_NFE = EST_NF_ENT_DANFE_PROVISORIO_PENDENTE_RESTORE.NR_AUTORIZADOR  

	PRINT 'Excluindo Danfes'
	DECLARE CExclusaoDanfe CURSOR FAST_FORWARD FOR 
											SELECT
												CD_CTR
											FROM
												EST_NF_ENT_DANFE_PROVISORIO_PENDENTE_RESTORE 

	OPEN CExclusaoDanfe
	FETCH NEXT FROM CExclusaoDanfe INTO 
						@CD_CTR
		WHILE @@FETCH_STATUS = 0 
			BEGIN	
				PRINT 'Apagando o DANFE'
				EXEC P_EST_NF_ENT_DANFE_PROVISORIO_EXCLUSAO @CD_CTR
				
				FETCH NEXT FROM CExclusaoDanfe INTO @CD_CTR
			END
		CLOSE CExclusaoDanfe
		DEALLOCATE CExclusaoDanfe

DROP TABLE #RsDanfePendente;
